<?php
session_start();

if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header("Location: dashboard.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $keyword = $_POST['keyword'];
    
    if ($keyword === 'amor') {
        $_SESSION['loggedin'] = true;
        $_SESSION['last_activity'] = time(); // Marca a hora do login
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Palavra-chave incorreta!";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistema IFCora</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="login-container">
        <h2>Login</h2>
        <form method="POST" action="">
            <label for="keyword">Palavra-chave</label>
            <input type="password" id="keyword" name="keyword" required>
            <button type="submit">Entrar</button>
            <?php if (isset($error)): ?>
                <p class="error"><?php echo $error; ?></p>
            <?php endif; ?>
        </form>
    </div>
</body>
</html>
