<?php
session_start();

// Verifica se o usuário está logado e se a sessão não expirou
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: index.php");
    exit();
}

// Opcional: expira a sessão após 30 minutos de inatividade
if (time() - $_SESSION['last_activity'] > 1800) { 
    session_unset();
    session_destroy();
    header("Location: index.php");
    exit();
}
$_SESSION['last_activity'] = time(); // Atualiza o timestamp da última atividade
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistema IFCora</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <header>
        <h1>Sistema IFCora</h1>
        <a href="logout.php" class="logout-btn"><i class="fas fa-sign-out-alt"></i> Logout</a>
    </header>
    <div class="dashboard">
        <h2>Dashboard</h2>
        <div class="modules">
            <a href="produto_tag/index.php" class="module">
                <i class="fas fa-tags"></i>
                Produto TAG
            </a>
            <a href="javascript:void(0);" class="module" onclick="window.open('https://webhook.ifcora.com.br/google-contact/oauth2.php', '_blank');">
                <i class="fas fa-plug"></i>
                Contact API
            </a>
            <a href="login_sso/index.php" class="module">
                <i class="fas fa-user-lock"></i>
                Login SSO
            </a>
        </div>
    </div>
</body>
</html>
