<?php
session_start();

// Verifica se o usuário está logado
if (!isset($_SESSION['loggedin'])) {
    // Se não estiver logado, redireciona para a página de login
    header("Location: ../../index.php");
    exit();
}

// Configurações do Banco de Dados
define('DB_SERVER', 'localhost');
define('DB_USERNAME', 'ifcora_admin');
define('DB_PASSWORD', 'Y4rwW52[0EQ_');
define('DB_NAME', 'ifcora_login_sso');

// Conexão com o Banco de Dados
$conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);

if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

// Carrega todos os registros
$sql = "SELECT id, CONCAT(first_name, ' ', last_name) AS full_name, email, phone, tag FROM temporary_urls";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login SSO - Registros AlpaClass</title>
    <link rel="stylesheet" href="style.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <header>
        <h1>Login SSO</h1>
        <a href="../dashboard.php" class="back-btn"><i class="fas fa-arrow-left"></i> Voltar ao Dashboard</a>
    </header>
    <div class="container">
        <h2>Registros AlpaClass</h2>
        <div class="filter-container">
            <input type="text" id="filter-name" placeholder="Filtrar por Nome">
            <input type="text" id="filter-email" placeholder="Filtrar por Email">
            <input type="text" id="filter-phone" placeholder="Filtrar por Telefone">
        </div>
        <div class="table-container">
            <table id="records-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>NOME COMPLETO</th>
                        <th>EMAIL</th>
                        <th>TELEFONE</th>
                        <th>TAG</th>
                        <th>AÇÕES</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php while($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo $row['full_name']; ?></td>
                                <td><?php echo $row['email']; ?></td>
                                <td><?php echo $row['phone']; ?></td>
                                <td><?php echo $row['tag']; ?></td>
                                <td class="actions">
                                    <a href="alterar.php?id=<?php echo $row['id']; ?>" class="edit-btn"><i class="fas fa-edit"></i> Alterar</a>
                                    <a href="javascript:void(0);" class="delete-btn" onclick="confirmDelete(<?php echo $row['id']; ?>)"><i class="fas fa-trash"></i> Remover</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="6">Nenhum registro encontrado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal de Confirmação de Exclusão -->
    <div id="deleteModal" class="modal">
        <div class="modal-content">
            <h3>Confirmar Exclusão</h3>
            <p>Tem certeza de que deseja remover este registro?</p>
            <div class="modal-actions">
                <button id="cancelBtn" class="modal-btn cancel-btn">Cancelar</button>
                <button id="confirmBtn" class="modal-btn confirm-btn">Remover</button>
            </div>
        </div>
    </div>

    <script>
        let deleteId = null;

        function confirmDelete(id) {
            deleteId = id;
            $("#deleteModal").show();
        }

        $("#cancelBtn").click(function() {
            $("#deleteModal").hide();
            deleteId = null;
        });

        $("#confirmBtn").click(function() {
            if (deleteId !== null) {
                window.location.href = "remover.php?id=" + deleteId;
            }
        });

        $(document).ready(function(){
            $("#filter-name, #filter-email, #filter-phone").on("keyup", function() {
                var nameValue = $("#filter-name").val().toLowerCase();
                var emailValue = $("#filter-email").val().toLowerCase();
                var phoneValue = $("#filter-phone").val().toLowerCase();
                
                $("#records-table tbody tr").filter(function() {
                    $(this).toggle(
                        $(this).find("td:eq(1)").text().toLowerCase().indexOf(nameValue) > -1 &&
                        $(this).find("td:eq(2)").text().toLowerCase().indexOf(emailValue) > -1 &&
                        $(this).find("td:eq(3)").text().toLowerCase().indexOf(phoneValue) > -1
                    );
                });
            });
        });
    </script>
</body>
</html>

<?php
$conn->close();
?>
