<?php

session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header("Location: ../../modulos/index.php");
    exit();
}

// Opcional: expira a sessão após 30 minutos de inatividade
if (time() - $_SESSION['last_activity'] > 1800) {
    session_unset();
    session_destroy();
    header("Location: ../../modulos/index.php");
    exit();
}
$_SESSION['last_activity'] = time(); // Atualiza o timestamp da última atividade




// Configurações do Banco de Dados
define('DB_SERVER', 'localhost');
define('DB_USERNAME', 'ifcora_admin');
define('DB_PASSWORD', 'Y4rwW52[0EQ_');
define('DB_NAME', 'ifcora_login_sso');

// Conexão com o Banco de Dados
$conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);

if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}

// Busca produtos no banco de dados
$sql = "SELECT * FROM produtos";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Eduzz - Produtos</title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <header>
        <h1>Produto TAG</h1>
        <a href="../dashboard.php" class="back-btn"><i class="fas fa-arrow-left"></i> Voltar ao Dashboard</a>
    </header>
    <div class="container">
        <h2>Eduzz - Produtos</h2>
        <a href="cadastrar.php" class="form-container button">Cadastrar Novo Produto</a>
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>ID Produto</th>
                        <th>Nome Produto</th>
                        <th>Tag</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php while($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo $row['id']; ?></td>
                                <td><?php echo $row['id_produto']; ?></td>
                                <td><?php echo $row['nome_produto']; ?></td>
                                <td><?php echo $row['tag']; ?></td>
                                <td>
                                    <a href="alterar.php?id=<?php echo $row['id']; ?>" class="edit-btn"><i class="fas fa-edit"></i> Alterar</a>
                                    <a href="remover.php?id=<?php echo $row['id']; ?>" class="delete-btn"><i class="fas fa-trash"></i> Remover</a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5">Nenhum produto encontrado.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>

<?php
$conn->close();
?>
